#ifndef IRDECODE_H
#define IRDECODE_H

enum Remote_Protocol{	
	BOOST = 		0xFE65, 
	POWER_SW = 		0xFE64,
	SPEED_LV1 = 	0xFCC2,
	SPEED_LV2 = 	0xFF3C,
	SPEED_LV3 = 	0xFE62,
	SPEED_LV4 = 	0xFE68,
	SPEED_LV5 = 	0xFCC8,
};
// <<< Use Configuration Wizard in Context Menu >>>
// <e> IR Enable/Disable
#define IR_Control 0
#if (IR_Control == 1)

	//<e> IR decoding to UR Enable
			#define IR_decoding_UR_Enable 	0
			
		// <o> 	Set the number of data to observe(Capture) <1-50> 
			#define	Ir_data_number_ur	1
	// </e>
			
	// <o> 	Set IR High Head counter_min (Capture) <0-65535> 
		#define	Ir_high_head_counter_min	21856
		
	// <o> 	Set IR High Head counter_MAX (Capture) <0-65535> 
		// <i> If the counter is close to 65535, it is recommended to go to Capture.h and slow down CAPCKS.
		#define	Ir_high_head_counter_max	24394
	
	// <o> 	Set IR High Head counter_error (Capture) <0-10000> 
		#define	Ir_high_head_counter_error	3000
	
	// <h> Set read IR data format
		// <o> IR_data_format <0=> Low_level <1=> High_level 
		// <i> Low  : data read-only low level
		// <i> High : data read-only high level
			#define IR_data_format 0
	//</h>
	
	// <o> 	Set IR 0 data counter  (Capture) <0-65535> 
		#define	Ir_0_data_counter	1257
		
	// <o> 	Set IR 1 data counter  (Capture) <0-65535> 
		#define	Ir_1_data_counter	3813
		
	// <o> 	Set IR data counter_error (Capture) <0-10000> 
		#define	Ir_data_counter_error	400
	
		#if ((Ir_0_data_counter+Ir_data_counter_error)>= (Ir_1_data_counter-Ir_data_counter_error))
			#error Wrong setting Ir_data_counter_error too many !!!!
		#endif
		
	// <o> 	Set the number of bits of IR data  (Capture) <0-50> 
		#define	Ir_data_number		8
	
	// <o> 	Set the number of bits of the IR address (Capture) <0-50> 
		#define	Ir_adress_number	4
	
	// <o> 	Set IR address value (Capture) <0-32767> 
		#define	IR_address_value	13
	
	// <h> 	IR data values set(Capture)
		// <o>  Button OFF<0-32767> 
			#define	IR_DATA_OFF				198
			
		// <o>  Button speed 1<0-32767> 
			#define	IR_DATA_SPEED1			160
			
		// <o>  Button speed 2<0-32767> 
			#define	IR_DATA_SPEED2			136
			
		// <o>  Button speed 3<0-32767> 
			#define	IR_DATA_SPEED3			132
			
		// <o>  Button speed 4<0-32767> 
			#define	IR_DATA_SPEED4			195
			
		// <o>  Button speed 5<0-32767> 
			#define	IR_DATA_SPEED5			144
			
		// <o>  Button SMART<0-32767> 
			#define	IR_DATA_SMART			129
			
		// <o>  Button 1H<0-32767> 
			#define	IR_DATA_1H				194
			
		// <o>  Button 2H<0-32767> 
			#define	IR_DATA_2H				200
			
		// <o>  Button 4H<0-32767> 
			#define	IR_DATA_4H				193
			
		// <o>  Button 6H<0-32767> 
			#define	IR_DATA_6H				204
			
		// <o>  Button 8H<0-32767> 
			#define	IR_DATA_8H				130
			
	//</h>
					
	// <o> 	IR Head code TIME set (unit : us)
		#define	ir_header_counter		128
		
	// <o> 	Set IR address1<0x00-0xFF>
		#define	ir_address1				0x20
		
	// <o> 	Set IR address2<0x00-0xFF>
		#define	ir_address2				0xFF
		
	// <h> 	IR data code set
		// <h>  Button speed 1
			// <o> Data code 1<0x00-0xFF>
				#define	IR_DATA_1_1			0x05
				
			// <o> Data code 2<0x00-0xFF>
				#define IR_DATA_1_2			0x0E
		//</h>
		
		// <h>  Button speed 2
			// <o> Data code 1<0x00-0xFF>
				#define	IR_DATA_2_1			0x07
				
			// <o> Data code 2<0x00-0xFF>
				#define IR_DATA_2_2			0x06
		//</h>
		
		// <h>  Button speed 3
			// <o> Data code 1<0x00-0xFF>
				#define	IR_DATA_3_1			0x07
				
			// <o> Data code 2<0x00-0xFF>
				#define IR_DATA_3_2			0x0A
		//</h>
		
		// <h>  Button speed 4
			// <o> Data code 1<0x00-0xFF>
				#define	IR_DATA_4_1			0x03
				
			// <o> Data code 2<0x00-0xFF>
				#define IR_DATA_4_2			0x0D
		//</h>
		
		// <h>  Button speed 5
			// <o> Data code 1<0x00-0xFF>
				#define	IR_DATA_5_1			0x06
				
			// <o> Data code 2<0x00-0xFF>
				#define IR_DATA_5_2			0x0E
		//</h>
		
		// <h>  Button Timer 1H
			// <o> Data code 1<0x00-0xFF>
				#define	IR_DATA_1H_1			0x03
				
			// <o> Data code 2<0x00-0xFF>
				#define IR_DATA_1H_2			0x0C
		//</h>
		
		// <h>  Button Timer 2H
			// <o> Data code 1<0x00-0xFF>
				#define	IR_DATA_2H_1			0x03
				
			// <o> Data code 2<0x00-0xFF>
				#define IR_DATA_2H_2			0x06
		//</h>
		
		// <h>  Button Timer 4H
			// <o> Data code 1<0x00-0xFF>
				#define	IR_DATA_4H_1			0x03
				
			// <o> Data code 2<0x00-0xFF>
				#define IR_DATA_4H_2			0x0F
		//</h>
		
		// <h>  Button Timer 6H
			// <o> Data code 1<0x00-0xFF>
				#define	IR_DATA_6H_1			0x03
				
			// <o> Data code 2<0x00-0xFF>
				#define IR_DATA_6H_2			0x02
		//</h>
		
		// <h>  Button Timer 8H
			// <o> Data code 1<0x00-0xFF>
				#define	IR_DATA_8H_1			0x07
				
			// <o> Data code 2<0x00-0xFF>
				#define IR_DATA_8H_2			0x0C
		//</h>
		
		// <h>  Button speed OFF
			// <o> Data code 1<0x00-0xFF>
				#define	IR_DATA_off_1		0x03
				
			// <o> Data code 2<0x00-0xFF>
				#define IR_DATA_off_2		0x08
		//</h>
		
		// <h>  Button SMART
			// <o> 	Data code 1<0x00-0xFF>	
				#define IR_DATA_smart_1			0x07
					
			// <o> Data code 2<0x00-0xFF>
				#define IR_DATA_smart_2			0x0F
		// </h>
	//</h>	
	
	extern 	void 	IRDecode(void);	
	extern 	void 	IRDecode_Read (void);
	extern 	void 	IR_Decode_error(void);
	extern 	void 	bit_check(unsigned int Capture_Level_buf);
	
	extern	xdata	uint8			capture_standby_times;
	extern	xdata 	unsigned char	ir_data_buf[4];
	extern	xdata 	uint16 			key_time;
	extern	xdata	uint16			Ir_data_buffer;
	
	#if(IR_decoding_UR_Enable==1)
		extern	xdata	uint16	Capture_High_Header;
		extern	xdata	uint16	Capture_Counter_ur;
		extern	xdata	uint16	Capture_Address_ur;
	#endif
	extern	uint16	test_pp;
#endif
// <<< end of configuration section >>>
extern data bit Power_On;
extern uint8 Power_SW_cnt;
void IrDA_Check(void);
void RemoteSpeedSet(uint16 RemoteSet);

extern void IrDA_Check(void);
extern void RemoteSpeedSet(uint16 RemoteSet);
#endif
